﻿<%@ Page Title="Referral Contact Log" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="ReferralContactLog.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.ReferralContactLog" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
   
    <asp:ObjectDataSource ID="ObjectDataSourcePatient" runat="server" 
        SelectMethod="GetPatientByReferralId" 
        TypeName="VIRP.EFR.BLL.ReferralManager">
        <SelectParameters>
                <asp:Parameter Name="CURRENT_USER" Type="String" />
                <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
                <asp:Parameter Name="REFERRAL_ID" Type="Int32" />
        </SelectParameters>       
    </asp:ObjectDataSource>
    <asp:FormView ID="FormViewPatientInformation" runat="server"  
        DataSourceID="ObjectDataSourcePatient" 
        Width="79%" 
        DataKeyNames = "PATIENT_ID" 
        Visible = "true">
    <FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
    <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
    <ItemTemplate>
        <asp:Panel ID="PanelPatient" runat="server" GroupingText="Patient" Width="100%" CssClass="efrContactLogPatientPanel">
            <table cellpadding="-1" cellspacing="-1" width="100%">
                <tr style = "height:20px;" >
                    <td style="width:20px;">
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelICN" runat="server" Text="ICN:" AssociatedControlID="VPIDLabel"></asp:Label>
                        <asp:Label SkinID="DataLabel" ID="VPIDLabel" runat="server"  Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("PATIENTICN"))) %>' />
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelName" runat="server" Text="Name:" AssociatedControlID="NameLabel"></asp:Label>
                        <asp:Label SkinID="DataLabel" ID="NameLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("LAST_NAME")))+ "," + "&nbsp;" + VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("FIRST_NAME"))) + "&nbsp;" + VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("MIDDLE_NAME")))%>' />
                    </td>
                    <td >
                        <asp:Label SkinID="DataLabel" ID="LabelForSSN" runat="server" Text="SSN:" AssociatedControlID="LabelSSN"></asp:Label>
                        <asp:Label SkinID="DataLabel" ID = "LabelSSN" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("SNUM"))) %>'  />
                    </td>
                    <td>
                         <asp:Label SkinID="DataLabel" ID="LabelForPostal" runat="server" Text="Zip Code:" AssociatedControlID="LabelPostal"></asp:Label>
                        <asp:Label SkinID="DataLabel" ID = "LabelPostal" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("POSTAL_CODE"))) %>'  />
                    </td>
                   
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForDOB" runat="server" Text="DOB:" AssociatedControlID="LabelDOB"></asp:Label>
                        <asp:Label SkinID="DataLabel" ID = "LabelDOB" runat = "server"  Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("BIRTH_DATE", "{0:d}"))) %>'/> 
                    </td>
                    <td>
                        &nbsp;
                    </td>
                    <td align = "left">
                    </td>
                </tr>
            </table>
    </asp:Panel>
     
    </ItemTemplate>
    </asp:FormView>
    <asp:Repeater ID = "EFRReferralChatLog" runat = "server"  
        DataSourceID = "ObjectDataSourceEFRReferralContactLog"  
        OnItemCommand = "EFRReferralChatLog_ItemCommand" OnItemDataBound = "EFRReferralChatLog_DataBound">
        <HeaderTemplate>
        <table id="TableLabResults" cellspacing="-2" cellpadding="2">
            <tr><td>&nbsp;</td></tr>
            <tr>
                <td>
                    <asp:Button ID = "NewButton" runat = "server" 
                        Text = "New Contact" 
                        CommandName = "Add"/>
                </td>   
                <td>
                    
                </td>          
            </tr>            
            <tr>
                <td colspan="2">
                    <hr style = "color:Black;"/> 
                </td>
            </tr>            
        </HeaderTemplate> 
        <SeparatorTemplate >
            <tr>
                <td colspan="2">
                    <hr style = "color:Black; width:100%" /> 
                </td>
            </tr>
        </SeparatorTemplate> 
        <ItemTemplate>
            <tr>
                <td colspan = "2">
                    <asp:HiddenField ID="ContactIDField" runat="server" 
                        Value='<%# Eval("ContactId") %>' />
                    <asp:Label SkinID="DataLabel" ID = "ConversationHeader" runat = "server" 
                        Text = '<%# "Between&nbsp;" + VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ContactName"))) + "&nbsp;and&nbsp;" + VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ContactInitiator"))) + 
                        "&nbsp;on&nbsp;" + VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ContactDate"))) %>'>
                    </asp:Label> 
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <asp:Label SkinID="DataLabel" ID = "ContactReason" runat = "server" 
                        Width="600px"
                        Text = '<%# "Reason:&nbsp;" + VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ContactReason"))) %>'>
                    </asp:Label>
                </td> 
            </tr>
            <tr>
                <td colspan="2">
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <asp:Label SkinID="DataLabel" ID = "ContactText" runat = "server"  
                        Width="600px"
                        Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ContactText"))) %>'>
                    </asp:Label>
                </td> 
            </tr>
            <tr>
                <td colspan="2">
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td style = "width:50%" align = "left" >
                    <asp:Label SkinID="DataLabel" ID = "ContactComments" runat = "server" 
                       Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("ContactComments"))) %>'>
                    </asp:Label>
                </td> 
                <td style = "width:50%" align = "left">
                    <asp:Button ID = "SelectButton" runat = "server" Text = "Select" CommandName = "Details" Width = "70px" />
                    <asp:Button ID = "DeleteButton" runat = "server" OnClientClick="return confirm('Are you sure you want to delete this Contact log entry?');"
                         Text = "Delete" CommandName = "DeleteContact" Enabled= '<%# EnableButtton() %>' Width = "70px" /> 
                </td>
            </tr>
        </ItemTemplate>
        <FooterTemplate>
            <tr>
                <td colspan="2">
                    <hr style = "color:Black; width:100%" /> 
                </td>
            </tr>
        </table> 
        </FooterTemplate>
    </asp:Repeater> 
    <asp:ObjectDataSource ID="ObjectDataSourceEFRReferralContactLog" runat="server"
        DataObjectTypeName = "VIRP.EFR.BO.CONTACT_LOG" 
        SelectMethod="SelectByID" 
        TypeName="VIRP.EFR.BLL.CONTACT_LOGManager">
        <SelectParameters>
                <asp:Parameter Name="CURRENT_USER" Type="String" />
                <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="Int32" />
                <asp:Parameter Name="id" Type="Int32" />
        </SelectParameters>       
     </asp:ObjectDataSource>
</asp:Content> 
